/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.ldap;

import com.softclouds.kapture.common.KapiException;
import com.softclouds.kapture.common.Utility;
import com.softclouds.kapture.model.AuthorizationDS;
import com.softclouds.kapture.model.LoginDS;
import com.softclouds.kapture.sha.SHA512;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Ldap {
    private String ldapUrl = Utility.getProperty("ldap.url");
    private String ldapUserDN = Utility.getProperty("ldap.dn");
    private String ldapPwd = Utility.getProperty("ldap.passwd");
    private static Logger logger = LogManager.getLogger(Ldap.class);

    public static void main(String[] args) {
        String user = "jtang";
        String password = "Ready2go";
        String surname = "Tang";
        String email = "jtang@gmail.com";
        String uid = "10001";
        String gid = "10001";
        boolean isValid = false;
        try {
            Ldap ldap = new Ldap();
            isValid = ldap.validateUser(user, password);
            if (isValid) {
                AuthorizationDS authorization = ldap.getAuthorization(user);
                logger.info("Credentials are valid: " + user + "/" + password);
            } else {
                logger.info("Credentials are not valid: " + user + "/" + password);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationDS getAuthorization(String user) throws NamingException, IOException {
        AuthorizationDS auth = new AuthorizationDS();
        LdapContext ctx = this.getLdapContext();
        String srchTarget = Utility.getProperty("ldap.user.dn") + user;
        List<String> list = null;
        try {
            list = this.getMembership(ctx, srchTarget, Utility.getProperty("ldap.groups.filter"), Utility.getProperty("ldap.groups.dn"));
            auth.setGroups(list.toString().replaceAll("\\[|\\]", ""));
            list = this.getMembership(ctx, srchTarget, Utility.getProperty("ldap.roles.filter"), Utility.getProperty("ldap.roles.dn"));
            auth.setRoles(list.toString().replaceAll("\\[|\\]", ""));
            list = this.getMembership(ctx, srchTarget, Utility.getProperty("ldap.views.filter"), Utility.getProperty("ldap.views.dn"));
            auth.setViews(list.toString().replaceAll("\\[|\\]", ""));
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        return auth;
    }

    private List<String> getMembership(LdapContext ctx, String srchTarget, String filter, String dn) throws NamingException, IOException {
        LinkedList<String> list = new LinkedList<String>();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        logger.info("Base dn: " + dn);
        NamingEnumeration<SearchResult> rs = ctx.search(dn, filter, sc);
        SearchResult result = null;
        Attribute attr = null;
        String members = null;
        String name = null;
        while (rs.hasMore()) {
            result = rs.next();
            attr = result.getAttributes().get("member");
            if (attr == null) {
                name = result.getNameInNamespace();
                continue;
            }
            name = this.extractName(result.getName());
            members = attr.toString();
            if (!members.contains(srchTarget)) continue;
            logger.info(srchTarget + " is a member of " + name);
            list.add(name);
        }
        return list;
    }

    private String extractName(String value) {
        if (value == null || value.length() == 0) {
            return "";
        }
        int pos = value.indexOf("=");
        String name = value.substring(pos + 1);
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLUserGroup(String groupName, String password, String gidNumber) throws NamingException, IOException {
        LdapContext ctx = this.getLdapContext();
        BasicAttributes attr = new BasicAttributes(true);
        attr.put(new BasicAttribute("objectclass", "posixGroup"));
        attr.put(new BasicAttribute("objectclass", "top"));
        attr.put(new BasicAttribute("cn", groupName));
        attr.put(new BasicAttribute("gidNumber", gidNumber));
        attr.put(new BasicAttribute("userPassword", password));
        String root = Utility.getProperty("ldap.root");
        try {
            ctx.bind("cn=" + groupName + ",ou=groups," + root, null, (Attributes)attr);
        }
        finally {
            ctx.close();
        }
    }

    public LdapContext getLdapContext() throws NamingException {
        return this.getLdapContext(this.ldapUrl, this.ldapUserDN, this.ldapPwd);
    }

    public LdapContext getLdapContext(String url, String userDN, String passwd) throws NamingException {
        InitialLdapContext ctx = null;
        Properties env = new Properties();
        env.put("java.naming.authoritative", "true");
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", userDN);
        env.put("java.naming.security.credentials", passwd);
        ctx = new InitialLdapContext(env, null);
        return ctx;
    }

    public void getUser(LoginDS login) throws NamingException, IOException {
        String filter;
        String dn = "uid=" + login.getUsername() + "," + Utility.getProperty("ldap.users.dn");
        NamingEnumeration<SearchResult> sr = this.getUser(dn, filter = Utility.getProperty("ldap.users.filter"));
        SearchResult result = sr.next();
        Attribute attr = result.getAttributes().get("sn");
        if (attr != null) {
            login.setLastname(attr.toString().replace("sn: ", ""));
        }
        if ((attr = result.getAttributes().get("givenName")) != null) {
            login.setFirstname(attr.toString().replace("givenName: ", ""));
        }
        if ((attr = result.getAttributes().get("mail")) != null) {
            login.setEmail(attr.toString().replace("mail: ", ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration<SearchResult> getUser(String dn, String filter) throws NamingException, IOException {
        NamingEnumeration<SearchResult> searchResults = null;
        LdapContext ctx = this.getLdapContext();
        SearchControls sc = new SearchControls();
        sc.setSearchScope(2);
        try {
            searchResults = ctx.search(dn, filter, sc);
        }
        finally {
            ctx.close();
        }
        return searchResults;
    }

    public NamingEnumeration<SearchResult> searchUser(String username, String password) throws IOException, NamingException {
        boolean isValid = false;
        String ldapRoot = Utility.getProperty("ldap.root");
        String user = "uid=" + username + "," + Utility.getProperty("ldap.users.dn");
        String filter = Utility.getProperty("ldap.users.filter");
        NamingEnumeration<SearchResult> rs = this.getUser(user, filter);
        return rs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validateUser(String username, String password) throws IOException, NamingException {
        LdapContext ctx = null;
        boolean isValid = true;
        String ldapRoot = Utility.getProperty("ldap.root");
        String userDN = "uid=" + username + ",ou=users," + ldapRoot;
        String url = Utility.getProperty("ldap.url");
        try {
            ctx = this.getLdapContext(url, userDN, password);
        }
        catch (AuthenticationException e) {
            isValid = false;
        }
        finally {
            if (ctx != null) {
                ctx.close();
            }
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createUser(String username, String password, String surname, String email, String uidNumber, String gidNumber) throws NamingException {
        try (LdapContext ctx = this.getLdapContext();){
            BasicAttributes attr = new BasicAttributes(true);
            BasicAttribute objclassSet = new BasicAttribute("objectClass");
            objclassSet.add("posixAccount");
            objclassSet.add("inetOrgPerson");
            objclassSet.add("person");
            attr.put(objclassSet);
            attr.put(new BasicAttribute("uid", username));
            attr.put(new BasicAttribute("cn", username));
            attr.put(new BasicAttribute("sn", surname));
            attr.put(new BasicAttribute("uidNumber", uidNumber));
            attr.put(new BasicAttribute("gidNumber", gidNumber));
            attr.put(new BasicAttribute("homeDirectory", "/home/" + username));
            attr.put(new BasicAttribute("userpassword", password));
            attr.put(new BasicAttribute("mail", email));
            attr.put(new BasicAttribute("description", "LDAP user."));
            ctx.bind("uid=" + username + ",ou=users,dc=softclouds,dc=com", null, (Attributes)attr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAccountPassword(String username, String password) throws KapiException, IOException, NamingException, NoSuchAlgorithmException {
        LdapContext ctx = this.getLdapContext();
        if (username == null || username.length() == 0) {
            throw new KapiException("The username parameter must be a valid value");
        }
        if (password == null || password.length() == 0) {
            throw new KapiException("At least one of the following must be valid: firstName, lastName");
        }
        try {
            String ldapRoot = Utility.getProperty("ldap.root");
            String dn = "uid=" + username + ",ou=users," + ldapRoot;
            String sha512 = new SHA512().generate(password);
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute("userPassword", sha512))};
            ctx.modifyAttributes(dn, mods);
        }
        finally {
            ctx.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeAccountName(String username, String firstName, String lastName, String displayName) throws KapiException, IOException, NamingException {
        LdapContext ctx = this.getLdapContext();
        ModificationItem[] mods = null;
        if (username == null || username.length() == 0) {
            throw new KapiException("The username parameter must be a valid value");
        }
        if (firstName == null && lastName == null && displayName == null) {
            throw new KapiException("At least one of the following must be valid: firstName, lastName, displayName");
        }
        if (firstName != null && firstName.length() == 0) {
            throw new KapiException("The parameter firstName can be null but it cannot be an empty string");
        }
        if (lastName != null && lastName.length() == 0) {
            throw new KapiException("The parameter lastName can be null but it cannot be an empty string");
        }
        if (displayName != null && displayName.length() == 0) {
            throw new KapiException("The parameter displayName can be null but it cannot be an empty string");
        }
        try {
            String ldapRoot = Utility.getProperty("ldap.root");
            String dn = "uid=" + username + ",ou=users," + ldapRoot;
            int modSize = 0;
            int arayPos = -1;
            if (firstName != null) {
                ++modSize;
            }
            if (lastName != null) {
                ++modSize;
            }
            if (displayName != null) {
                ++modSize;
            }
            mods = new ModificationItem[modSize];
            if (firstName != null) {
                mods[++arayPos] = new ModificationItem(2, new BasicAttribute("givenName", firstName));
            }
            if (lastName != null) {
                mods[++arayPos] = new ModificationItem(2, new BasicAttribute("sn", lastName));
            }
            if (displayName != null) {
                mods[++arayPos] = new ModificationItem(2, new BasicAttribute("displayName", displayName));
            }
            ctx.modifyAttributes(dn, mods);
        }
        finally {
            ctx.close();
        }
    }
}

