/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.kwatcher;

import com.softclouds.kapture.common.Db;
import com.softclouds.kapture.common.Utility;
import com.softclouds.kapture.kwatcher.FileAlterationListenerImpl;
import com.softclouds.kapture.kwatcher.GmailClient;
import com.softclouds.kapture.kwatcher.Watcher;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.monitor.FileAlterationMonitor;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WatcherImpl
implements Watcher {
    private WatchService watcher = null;
    private Map<WatchKey, Path> keys = null;
    private boolean recursive = true;
    private boolean trace = false;
    private Logger logger = LogManager.getLogger(Watcher.class.getName());

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.OVERFLOW, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (this.trace) {
            Path prev = this.keys.get(key);
            if (prev == null) {
                this.logger.info("register: " + dir);
                String path = dir.toString();
                if (path.indexOf("~secure") > 0) {
                    this.saveEvent("CREATE_DIR", path);
                }
            } else if (!dir.equals(prev)) {
                this.logger.info("update: " + prev + "->" + dir);
            }
        }
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatcherImpl.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    WatcherImpl(Path dir, boolean recursive) throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.keys = new HashMap<WatchKey, Path>();
        this.recursive = recursive;
        if (recursive) {
            this.logger.info("Scanning " + dir + "\n");
            this.registerAll(dir);
            this.logger.info("Done.");
        } else {
            this.register(dir);
        }
        this.trace = true;
    }

    @Override
    public void processEvents() {
        while (true) {
            WatchKey key;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                String watchDir = null;
                try {
                    watchDir = Utility.getProperty("kwatcher.watchDir");
                    WatcherImpl.whileFailWatcherServiceAlterationMonitor(Paths.get(watchDir, new String[0]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) {
                this.logger.error("WatchKey not recognized: " + key.toString());
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = WatcherImpl.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                String childPath = child.toString();
                if (childPath.indexOf(".xml") > 0) {
                    this.saveEvent(event.kind().name(), childPath);
                }
                if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException ex) {
                    this.logger.error(ex.getMessage());
                    this.eventFailureEmailSent("RECURSIVELY_READ_FAIL_DIR", "REGISTER_PATH_FAIL", ex.getMessage());
                }
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    private void saveEvent(String event, String path) {
        try {
            this.logger.info("Call Db class to save " + event + "::" + path);
            Db.saveTransaction(event, path);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.error("Watcher.saveEvent error: " + e.getMessage());
            this.eventFailureEmailSent(event, path, e.getMessage());
        }
    }

    private void eventFailureEmailSent(String event, String path, String failureMessage) {
        GmailClient clGmailClient = new GmailClient();
        Object bodyContent = "" + WatcherImpl.registerFileReader("kwatcherFail");
        bodyContent = ((String)bodyContent).replaceAll("eventxx", event);
        bodyContent = ((String)bodyContent).replaceAll("pathxx", path);
        bodyContent = ((String)bodyContent).replaceAll("failMessagexx", failureMessage);
        try {
            clGmailClient.sendGmail("PratikJ@softclouds.com", "kwatcherfailure", (String)bodyContent);
        }
        catch (IOException e) {
            e.printStackTrace();
            this.logger.error("Failed to Send to Email ::eventFailureEmailSent()::" + e.getMessage());
        }
    }

    static void usage() {
        String msg = "usage: java Watch [-r] dir";
        System.err.println(msg);
        System.exit(-1);
    }

    public static StringBuffer registerFileReader(String type) {
        StringBuffer stringBuffer = new StringBuffer();
        String fileName = "";
        if (type.equals("kwatcherFail")) {
            fileName = "kwatcherfailure.txt";
        }
        ClassLoader classLoader = new GmailClient().getClass().getClassLoader();
        try {
            String line;
            File file = new File(classLoader.getResource(fileName).getFile());
            FileReader fileReader = new FileReader(file);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((line = bufferedReader.readLine()) != null) {
                stringBuffer.append(line);
            }
            fileReader.close();
        }
        catch (IOException e) {
            System.out.println("error in registerFileReader ");
            e.printStackTrace();
        }
        return stringBuffer;
    }

    public static Path whileFailWatcherServiceAlterationMonitor(Path dir) {
        long pollingInterval = 20000L;
        File directory = new File(dir.toString());
        FileAlterationObserver fao = new FileAlterationObserver(directory);
        fao.addListener(new FileAlterationListenerImpl());
        FileAlterationMonitor monitor = new FileAlterationMonitor(20000L);
        monitor.addObserver(fao);
        try {
            monitor.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dir;
    }

    public static void main(String[] args) throws IOException {
        boolean recursive = false;
        boolean dirArg = false;
        Path dir = null;
        String watchDir = Utility.getProperty("kwatcher.watchDir");
        String recursiveStr = Utility.getProperty("kwatcher.recursive");
        System.out.println("WatchDIR::: > " + watchDir + " :: recursiveStr :::" + recursiveStr);
        if (recursiveStr.equals("true")) {
            recursive = true;
        }
        dir = Paths.get(watchDir, new String[0]);
        try {
            new WatcherImpl(dir, recursive).processEvents();
        }
        catch (IOException e) {
            WatcherImpl.whileFailWatcherServiceAlterationMonitor(dir);
            e.printStackTrace();
        }
    }
}

