/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.kwatcher;

import com.amazonaws.auth.PropertiesCredentials;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.simpleemail.AWSJavaMailTransport;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailService;
import com.amazonaws.services.simpleemail.AmazonSimpleEmailServiceClient;
import com.amazonaws.services.simpleemail.model.ListVerifiedEmailAddressesResult;
import com.amazonaws.services.simpleemail.model.VerifyEmailAddressRequest;
import com.softclouds.kapture.kwatcher.ASESMailService;
import java.io.IOException;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GmailClient {
    private static Logger logger = LogManager.getLogger(GmailClient.class.getName());
    private String to;
    private String subject;
    private String text;
    private static String bodyText = null;
    private static final String from = "PratikJ@softclouds.com";

    public void sendGmail(String mailId, String type, String bodyContent) throws IOException {
        this.to = mailId;
        if (type.equals("kwatcherfailure")) {
            System.out.println("Type::" + type);
            this.subject = "kwatcher failure";
            bodyText = bodyContent;
        }
        this.text = bodyText;
        PropertiesCredentials credentials = new PropertiesCredentials(ASESMailService.class.getResourceAsStream("/awsASESCredentials.properties"));
        AmazonSimpleEmailServiceClient ses = new AmazonSimpleEmailServiceClient(credentials);
        ses.setRegion(Region.getRegion(Regions.US_WEST_2));
        System.out.println("from Email Id::PratikJ@softclouds.com");
        Properties props = new Properties();
        props.setProperty("mail.transport.protocol", "aws");
        props.setProperty("mail.aws.user", credentials.getAWSAccessKeyId());
        props.setProperty("mail.aws.password", credentials.getAWSSecretKey());
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.starttls.enable", "true");
        props.put("mail.smtp.host", "s3-us-west-2.amazonaws.com");
        props.put("mail.smtp.port", (Object)465);
        Session session1 = Session.getDefaultInstance(props);
        MimeMessage simpleMessage = new MimeMessage(session1);
        InternetAddress fromAddress = null;
        InternetAddress toAddress = null;
        try {
            fromAddress = new InternetAddress(from);
            toAddress = new InternetAddress(this.to);
        }
        catch (AddressException e) {
            e.printStackTrace();
            logger.error("Error occured while sending email ::" + e.getMessage());
        }
        try {
            ((Message)simpleMessage).setFrom(fromAddress);
            simpleMessage.setRecipient(Message.RecipientType.TO, toAddress);
            ((Message)simpleMessage).setSubject(this.subject);
            simpleMessage.setContent(this.text, "text/html");
            AWSJavaMailTransport transport = new AWSJavaMailTransport(session1, null);
            transport.connect();
            ((Transport)transport).sendMessage(simpleMessage, ((Message)simpleMessage).getAllRecipients());
            ((Service)transport).close();
            logger.info("Mail Sent.");
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Error occured while sending email ::" + e.getMessage());
        }
    }

    private static void verifyEmailAddress(AmazonSimpleEmailService ses, String address) {
        System.out.println("verifyEmailAddress:");
        ListVerifiedEmailAddressesResult verifiedEmails = ses.listVerifiedEmailAddresses();
        if (verifiedEmails.getVerifiedEmailAddresses().contains(address)) {
            return;
        }
        ses.verifyEmailAddress(new VerifyEmailAddressRequest().withEmailAddress(address));
        System.out.println("Please check the email address " + address + " to verify it");
        System.exit(0);
    }
}

