/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.kwatcher;

import com.softclouds.kapture.common.Db;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Date;
import org.apache.commons.io.monitor.FileAlterationListener;
import org.apache.commons.io.monitor.FileAlterationObserver;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileAlterationListenerImpl
implements FileAlterationListener {
    private Logger logger = LogManager.getLogger(FileAlterationListenerImpl.class.getName());

    @Override
    public void onStart(FileAlterationObserver observer) {
        this.logger.info("The FileListener has started on " + observer.getDirectory().getAbsolutePath());
    }

    @Override
    public void onDirectoryCreate(File directory) {
        this.logger.info(directory.getAbsolutePath() + " was created.");
    }

    @Override
    public void onDirectoryChange(File directory) {
        this.logger.info(directory.getAbsolutePath() + " wa modified");
    }

    @Override
    public void onDirectoryDelete(File directory) {
        this.logger.info(directory.getAbsolutePath() + " was deleted.");
    }

    @Override
    public void onFileCreate(File file) {
        this.logger.info(file.getAbsoluteFile() + " was created.");
        this.logger.info("1. length: " + file.length());
        this.logger.info("2. last modified: " + new Date(file.lastModified()));
        this.logger.info("3. readable: " + file.canRead());
        this.logger.info("4. writable: " + file.canWrite());
        this.logger.info("5. executable: " + file.canExecute());
        try {
            Db.saveTransaction("ENTRY_CREATE", file.getAbsolutePath());
        }
        catch (IOException | SQLException e) {
            this.logger.error("Failed to save onFileCreate" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onFileChange(File file) {
        this.logger.info(file.getAbsoluteFile() + " was modified.");
        this.logger.info("1. length: " + file.length());
        this.logger.info("2. last modified: " + new Date(file.lastModified()));
        this.logger.info("3. readable: " + file.canRead());
        this.logger.info("4. writable: " + file.canWrite());
        this.logger.info("5. executable: " + file.canExecute());
        try {
            Db.saveTransaction("ENTRY_MODIFY", file.getAbsolutePath());
        }
        catch (IOException | SQLException e) {
            this.logger.error("Failed to save onFileModify" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onFileDelete(File file) {
        this.logger.info(file.getAbsoluteFile() + " was deleted.");
        try {
            Db.saveTransaction("ENTRY_DELETE", file.getAbsolutePath());
        }
        catch (IOException | SQLException e) {
            this.logger.error("Failed to save onFileDelete" + e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void onStop(FileAlterationObserver observer) {
        this.logger.info("The FileListener has stopped on " + observer.getDirectory().getAbsolutePath());
    }
}

