/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.kapi;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.softclouds.kapture.common.Utility;
import com.softclouds.kapture.model.BaseDS;
import com.softclouds.kapture.model.LoginDS;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONObject;

public class BaseSvc {
    private static Logger logger = LogManager.getLogger(BaseSvc.class);

    protected String getSignedJWT(LoginDS login, boolean useExpiredDate) throws IOException, ParseException, JOSEException {
        return this.getSignedJWT(login, useExpiredDate, "kapi");
    }

    protected String getSignedJWT(LoginDS login, boolean useExpiredDate, String subject) throws IOException, ParseException, JOSEException {
        RSAKey rsaJWK = this.getRSAKey();
        RSAKey rsaPublicJWK = rsaJWK.toPublicJWK();
        RSASSASigner signer = new RSASSASigner(rsaJWK);
        String expDurStr = Utility.getProperty("jwt.claim.expirationDuration");
        long expDuration = 0L;
        Date now = null;
        Date expDate = null;
        if (useExpiredDate) {
            expDate = new Date(System.currentTimeMillis() - 1000000000000L);
        } else {
            now = new Date();
            expDuration = Long.valueOf(expDurStr);
            expDate = new Date(now.getTime() + expDuration);
        }
        return this.getSignedJWT(login, expDate, subject);
    }

    protected String getSignedJWT(LoginDS login, Date expDate, String subject) throws IOException, ParseException, JOSEException {
        RSAKey rsaJWK = this.getRSAKey();
        RSAKey rsaPublicJWK = rsaJWK.toPublicJWK();
        RSASSASigner signer = new RSASSASigner(rsaJWK);
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(subject).issuer(Utility.getProperty("jwt.claim.issuer")).expirationTime(expDate).claim("kapturePayload", login.toString()).build();
        SignedJWT signedJWT = new SignedJWT(new JWSHeader.Builder(JWSAlgorithm.RS256).keyID(rsaJWK.getKeyID()).build(), claimsSet);
        signedJWT.sign(signer);
        String s = signedJWT.serialize();
        return s;
    }

    protected RSAKey getRSAKey() throws IOException, ParseException {
        String key = Utility.getProperty("jwt.rsa.jwk");
        RSAKey rsaJWK = RSAKey.parse(key);
        return rsaJWK;
    }

    protected boolean expired(JWTClaimsSet claim) {
        boolean hasExpired = true;
        Date now = new Date();
        Date exp = claim.getExpirationTime();
        if (now.before(claim.getExpirationTime())) {
            logger.info("Expiration has been verified");
            hasExpired = false;
        } else {
            logger.info("Claim has expired");
        }
        return hasExpired;
    }

    protected boolean badSignature(SignedJWT signedJWT, JWTClaimsSet claim) throws IOException, ParseException, JOSEException {
        boolean isValid = true;
        RSAKey rsaPublicJWK = Utility.getPublicKey();
        RSASSAVerifier verifier = new RSASSAVerifier(rsaPublicJWK);
        if (signedJWT.verify(verifier)) {
            isValid = false;
        }
        return isValid;
    }

    protected LoginDS getLogin(JWTClaimsSet claim) throws IOException {
        LoginDS login = null;
        String payload = (String)claim.getClaim("kapturePayload");
        if (payload != null) {
            ObjectMapper mapper = new ObjectMapper();
            login = mapper.readValue(payload, LoginDS.class);
        }
        return login;
    }

    protected Object[] verifySignedClaim(String jwk, BaseDS ds) throws ParseException, IOException, JOSEException {
        SignedJWT signedJWT = SignedJWT.parse(jwk);
        JWTClaimsSet claim = signedJWT.getJWTClaimsSet();
        Object[] rc = new Object[]{signedJWT, claim};
        if (this.badSignature(signedJWT, claim)) {
            ds.setStatusText("RSA signature is not valid");
            ds.setStatusCode(0);
            ds.setStatus("Failure");
            logger.info("RSA signature is not valid");
        } else if (this.expired(claim)) {
            ds.setStatusText("JWT has expired");
            ds.setStatusCode(0);
            ds.setStatus("Failure");
            logger.info("JWT has expired");
        }
        return rc;
    }

    protected String getStackTrace(Exception e) {
        StringWriter errors = new StringWriter();
        e.printStackTrace(new PrintWriter(errors));
        return errors.toString();
    }

    protected String createRecordId() {
        return this.createGuid();
    }

    protected String createGuid() {
        return UUID.randomUUID().toString();
    }

    protected String removeFailuresObj(String jsonStr) {
        JSONObject json = new JSONObject(jsonStr);
        JSONObject shards = json.getJSONObject("_shards");
        if (shards != null) {
            shards.remove("failures");
        }
        return json.toString();
    }

    protected Date createTs(String value) throws ParseException {
        Date dt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").parse(value);
        return dt;
    }

    protected Timestamp createSqlTimestamp(String value) throws ParseException {
        Date dt = this.createTs(value);
        Timestamp sqlDate = new Timestamp(dt.getTime());
        sqlDate.setTime(dt.getTime());
        return sqlDate;
    }

    protected String createTs(Timestamp ts) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.US);
        formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dt = formatter.format(ts);
        return dt;
    }

    protected String createTs() {
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        return this.createTs(ts);
    }

    protected int[] isInteger(String value) {
        int num = -10;
        int[] rc = new int[]{1, -10};
        try {
            rc[1] = num = Integer.valueOf(value).intValue();
        }
        catch (NumberFormatException e) {
            rc[0] = 0;
        }
        return rc;
    }

    protected boolean isValidTs(String value) {
        boolean rc = true;
        try {
            this.createSqlTimestamp(value);
        }
        catch (Exception e) {
            rc = false;
        }
        return rc;
    }

    protected boolean isValidNumber(String value) {
        int[] rc = this.isInteger(value);
        return rc[0] == 1;
    }
}

