/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.kapi;

import com.softclouds.kapture.common.Db;
import com.softclouds.kapture.common.KapiException;
import com.softclouds.kapture.common.Utility;
import com.softclouds.kapture.kapi.BaseSvc;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class Analytics
extends BaseSvc {
    public void saveUserSearch(String username, String firstname, String lastname, String email, String q, String category, String locale) throws KapiException, IOException, SQLException {
        this.validateParameters(username, q, category);
        Timestamp ts = new Timestamp(System.currentTimeMillis());
        this.saveToDb(ts, username, firstname, lastname, email, q, category, locale);
        this.saveToES(ts, username, firstname, lastname, email, q, category, locale);
    }

    private void saveToES(Timestamp ts, String username, String firstname, String lastname, String email, String q, String category, String locale) throws IOException, KapiException {
        String dt = this.createTs(ts);
        StringBuffer result = new StringBuffer();
        String url = Utility.getProperty("elk.es.logstash.kapi.analytics.url");
        StringBuilder builder = new StringBuilder();
        builder.append("{");
        this.appendToBuilder(builder, "searchDt", dt, true);
        this.appendToBuilder(builder, "username", username, true);
        this.appendToBuilder(builder, "firstname", firstname, true);
        this.appendToBuilder(builder, "lastname", lastname, true);
        this.appendToBuilder(builder, "email", email, true);
        this.appendToBuilder(builder, "locale", locale, true);
        this.appendToBuilder(builder, "question", q, true);
        this.appendToBuilder(builder, "category", category, true);
        this.appendToBuilder(builder, "indexname", "kapi_analytics_user_searches", false);
        builder.append("}");
        StringEntity params = new StringEntity(builder.toString());
        HttpPost post = new HttpPost(url);
        post.addHeader("content-type", "text/plain");
        post.setEntity(params);
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        HttpResponse response = httpClient.execute(post);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode != 200) {
            BufferedReader br = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            String line = "";
            while ((line = br.readLine()) != null) {
                result.append(line);
            }
            throw new KapiException(result.toString());
        }
    }

    private StringBuilder appendToBuilder(StringBuilder builder, String name, String value, boolean addComma) {
        builder.append("\"").append(name).append("\" : \"").append(value).append("\"");
        if (addComma) {
            builder.append(", ");
        }
        return builder;
    }

    private void validateParameters(String username, String q, String category) throws KapiException {
        if (username == null || username.length() == 0) {
            throw new KapiException("The username parameter cannot be null or an empty string");
        }
        if (q == null || q.length() == 0) {
            throw new KapiException("The question parameter cannot be null or an empty string");
        }
        if (category != null && category.length() == 0) {
            throw new KapiException("The category parameter must be null or a non-empty string");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDb(Timestamp ts, String username, String firstname, String lastname, String email, String q, String category, String locale) throws IOException, SQLException {
        String SQL = this.getDbSql(q, category);
        Connection conn = null;
        Statement ps = null;
        int rc = 0;
        try {
            conn = Db.getDataSource().getConnection();
            ps = conn.prepareStatement(SQL);
            ps.setTimestamp(1, ts);
            ps.setString(2, username);
            ps.setString(3, firstname);
            ps.setString(4, lastname);
            ps.setString(5, email);
            ps.setString(6, q);
            ps.setString(7, locale);
            if (category != null) {
                ps.setString(8, category);
            }
            rc = ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private String getDbSql(String q, String category) {
        if (category == null) {
            return "insert into im_user_searches (search_ts, username, firstname, lastname, email, question, locale) values (?, ?, ?, ?, ?, ?, ?)";
        }
        return "insert into im_user_searches (search_ts, username, firstname, lastname, email, question, locale, category) values (?, ?, ?, ?, ?, ?, ?, ?)";
    }
}

