/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.common;

import com.nimbusds.jose.jwk.RSAKey;
import com.softclouds.kapture.common.Constants;
import java.io.IOException;
import java.text.ParseException;
import java.util.Properties;

public class Utility {
    private static Properties properties = null;

    public static int getIntProperty(String key) throws IOException {
        String value = Utility.getProperties().getProperty(key);
        return Integer.valueOf(value);
    }

    public static boolean getBooleanProperty(String key) throws IOException {
        String value = Utility.getProperties().getProperty(key);
        return Boolean.valueOf(value);
    }

    public static String getProperty(String key) throws IOException {
        return Utility.getProperties().getProperty(key);
    }

    private static Properties getProperties() throws IOException {
        if (properties == null) {
            properties = new Properties();
            properties.load(Utility.class.getClassLoader().getResourceAsStream(Constants.PROP_FILE_NAME));
        }
        return properties;
    }

    public static RSAKey getPublicKey() throws IOException, ParseException {
        String key = Utility.getProperty("jwt.rsa.jwk");
        RSAKey rsaPublicJWK = RSAKey.parse(key);
        return rsaPublicJWK;
    }

    public static String getLanguage(String locale) {
        String[] aray = locale.split("_");
        return aray[0];
    }

    public static String getGetChannel(String docid) {
        String channel = docid.replaceAll("\\d", "").toLowerCase();
        return channel;
    }

    public static StringBuilder append(StringBuilder sb, String name, String value) {
        if (value == null) {
            return sb;
        }
        if (sb.length() > 1) {
            sb.append(",");
        }
        sb.append("\"" + name + "\": \"").append(value).append("\"");
        return sb;
    }

    public static StringBuilder append(StringBuilder sb, String name, int value) {
        if (sb.length() > 1) {
            sb.append(",");
        }
        sb.append("\"" + name + "\": \"").append(value).append("\"");
        return sb;
    }
}

