/*
 * Decompiled with CFR 0.152.
 */
package com.softclouds.kapture.common;

import com.softclouds.kapture.common.Constants;
import com.softclouds.kapture.common.Utility;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Db {
    private static Logger logger = LogManager.getLogger(Db.class.getName());
    private static BasicDataSource ds;

    public static BasicDataSource getDataSource() throws IOException {
        if (ds == null) {
            String dbHost = Utility.getProperty("db.host");
            String dbPort = Utility.getProperty("db.port");
            String username = Utility.getProperty("db.username");
            String password = Utility.getProperty("db.password");
            String dbName = Utility.getProperty("db.dbname");
            int minIdle = Integer.valueOf(Utility.getProperty("db.minIdle"));
            int maxIdle = Integer.valueOf(Utility.getProperty("db.maxIdle"));
            int maxOpenPs = Integer.valueOf(Utility.getProperty("db.maxOpenPs"));
            String url = "jdbc:mysql://" + dbHost + ":" + dbPort + "/" + dbName;
            logger.debug("Connecting using  " + username + ", " + password + ", " + url);
            ds = new BasicDataSource();
            ds.setDriverClassName("com.mysql.cj.jdbc.Driver");
            ds.setUrl(url);
            ds.setUsername(username);
            ds.setPassword(password);
            ds.setMinIdle(minIdle);
            ds.setMaxIdle(maxIdle);
            ds.setMaxOpenPreparedStatements(maxOpenPs);
        }
        return ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveTransaction(String event, String path) throws IOException, SQLException {
        logger.debug("Start saving transaction " + event + " to database: " + path);
        Connection conn = null;
        Statement ps = null;
        try {
            conn = Db.getDataSource().getConnection();
            ps = conn.prepareStatement(Constants.SQL_IM_TRANS_INSERT);
            ps.setString(1, event);
            ps.setString(2, path);
            ps.execute();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }
}

