/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cognitosync.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.cognitosync.model.BulkPublishRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class BulkPublishRequestMarshaller
implements Marshaller<Request<BulkPublishRequest>, BulkPublishRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public BulkPublishRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<BulkPublishRequest> marshall(BulkPublishRequest bulkPublishRequest) {
        if (bulkPublishRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)bulkPublishRequest, "AmazonCognitoSync");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/identitypools/{IdentityPoolId}/bulkpublish";
        uriResourcePath = uriResourcePath.replace("{IdentityPoolId}", bulkPublishRequest.getIdentityPoolId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)bulkPublishRequest.getIdentityPoolId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
        }
        return request;
    }
}

