/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.MethodSetting;
import com.amazonaws.services.apigateway.model.Stage;
import com.amazonaws.services.apigateway.model.transform.MethodSettingJsonMarshaller;
import java.util.Map;

public class StageJsonMarshaller {
    private static StageJsonMarshaller instance;

    public void marshall(Stage stage, StructuredJsonGenerator jsonGenerator) {
        if (stage == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> variablesMap;
            Map<String, MethodSetting> methodSettingsMap;
            jsonGenerator.writeStartObject();
            if (stage.getDeploymentId() != null) {
                jsonGenerator.writeFieldName("deploymentId").writeValue(stage.getDeploymentId());
            }
            if (stage.getClientCertificateId() != null) {
                jsonGenerator.writeFieldName("clientCertificateId").writeValue(stage.getClientCertificateId());
            }
            if (stage.getStageName() != null) {
                jsonGenerator.writeFieldName("stageName").writeValue(stage.getStageName());
            }
            if (stage.getDescription() != null) {
                jsonGenerator.writeFieldName("description").writeValue(stage.getDescription());
            }
            if (stage.getCacheClusterEnabled() != null) {
                jsonGenerator.writeFieldName("cacheClusterEnabled").writeValue(stage.getCacheClusterEnabled().booleanValue());
            }
            if (stage.getCacheClusterSize() != null) {
                jsonGenerator.writeFieldName("cacheClusterSize").writeValue(stage.getCacheClusterSize());
            }
            if (stage.getCacheClusterStatus() != null) {
                jsonGenerator.writeFieldName("cacheClusterStatus").writeValue(stage.getCacheClusterStatus());
            }
            if ((methodSettingsMap = stage.getMethodSettings()) != null) {
                jsonGenerator.writeFieldName("methodSettings");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, MethodSetting> methodSettingsMapValue : methodSettingsMap.entrySet()) {
                    if (methodSettingsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(methodSettingsMapValue.getKey());
                    MethodSettingJsonMarshaller.getInstance().marshall(methodSettingsMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            if ((variablesMap = stage.getVariables()) != null) {
                jsonGenerator.writeFieldName("variables");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> variablesMapValue : variablesMap.entrySet()) {
                    if (variablesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(variablesMapValue.getKey());
                    jsonGenerator.writeValue(variablesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (stage.getCreatedDate() != null) {
                jsonGenerator.writeFieldName("createdDate").writeValue(stage.getCreatedDate());
            }
            if (stage.getLastUpdatedDate() != null) {
                jsonGenerator.writeFieldName("lastUpdatedDate").writeValue(stage.getLastUpdatedDate());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StageJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StageJsonMarshaller();
        }
        return instance;
    }
}

