/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PutIntegrationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

public class PutIntegrationRequestMarshaller
implements Marshaller<Request<PutIntegrationRequest>, PutIntegrationRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public PutIntegrationRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutIntegrationRequest> marshall(PutIntegrationRequest putIntegrationRequest) {
        if (putIntegrationRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putIntegrationRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putIntegrationRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putIntegrationRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", putIntegrationRequest.getResourceId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putIntegrationRequest.getResourceId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", putIntegrationRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putIntegrationRequest.getHttpMethod()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            List<String> cacheKeyParametersList;
            Map<String, String> requestTemplatesMap;
            Map<String, String> requestParametersMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (putIntegrationRequest.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(putIntegrationRequest.getType());
            }
            if (putIntegrationRequest.getIntegrationHttpMethod() != null) {
                jsonGenerator.writeFieldName("httpMethod").writeValue(putIntegrationRequest.getIntegrationHttpMethod());
            }
            if (putIntegrationRequest.getUri() != null) {
                jsonGenerator.writeFieldName("uri").writeValue(putIntegrationRequest.getUri());
            }
            if (putIntegrationRequest.getCredentials() != null) {
                jsonGenerator.writeFieldName("credentials").writeValue(putIntegrationRequest.getCredentials());
            }
            if ((requestParametersMap = putIntegrationRequest.getRequestParameters()) != null) {
                jsonGenerator.writeFieldName("requestParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestParametersMapValue.getKey());
                    jsonGenerator.writeValue(requestParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((requestTemplatesMap = putIntegrationRequest.getRequestTemplates()) != null) {
                jsonGenerator.writeFieldName("requestTemplates");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestTemplatesMapValue : requestTemplatesMap.entrySet()) {
                    if (requestTemplatesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestTemplatesMapValue.getKey());
                    jsonGenerator.writeValue(requestTemplatesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (putIntegrationRequest.getPassthroughBehavior() != null) {
                jsonGenerator.writeFieldName("passthroughBehavior").writeValue(putIntegrationRequest.getPassthroughBehavior());
            }
            if (putIntegrationRequest.getCacheNamespace() != null) {
                jsonGenerator.writeFieldName("cacheNamespace").writeValue(putIntegrationRequest.getCacheNamespace());
            }
            if ((cacheKeyParametersList = putIntegrationRequest.getCacheKeyParameters()) != null) {
                jsonGenerator.writeFieldName("cacheKeyParameters");
                jsonGenerator.writeStartArray();
                for (String cacheKeyParametersListValue : cacheKeyParametersList) {
                    if (cacheKeyParametersListValue == null) continue;
                    jsonGenerator.writeValue(cacheKeyParametersListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

