/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.Integration;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import com.amazonaws.services.apigateway.model.transform.IntegrationResponseJsonMarshaller;
import java.util.List;
import java.util.Map;

public class IntegrationJsonMarshaller {
    private static IntegrationJsonMarshaller instance;

    public void marshall(Integration integration, StructuredJsonGenerator jsonGenerator) {
        if (integration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, IntegrationResponse> integrationResponsesMap;
            List<String> cacheKeyParametersList;
            Map<String, String> requestTemplatesMap;
            Map<String, String> requestParametersMap;
            jsonGenerator.writeStartObject();
            if (integration.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(integration.getType());
            }
            if (integration.getHttpMethod() != null) {
                jsonGenerator.writeFieldName("httpMethod").writeValue(integration.getHttpMethod());
            }
            if (integration.getUri() != null) {
                jsonGenerator.writeFieldName("uri").writeValue(integration.getUri());
            }
            if (integration.getCredentials() != null) {
                jsonGenerator.writeFieldName("credentials").writeValue(integration.getCredentials());
            }
            if ((requestParametersMap = integration.getRequestParameters()) != null) {
                jsonGenerator.writeFieldName("requestParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestParametersMapValue.getKey());
                    jsonGenerator.writeValue(requestParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((requestTemplatesMap = integration.getRequestTemplates()) != null) {
                jsonGenerator.writeFieldName("requestTemplates");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestTemplatesMapValue : requestTemplatesMap.entrySet()) {
                    if (requestTemplatesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(requestTemplatesMapValue.getKey());
                    jsonGenerator.writeValue(requestTemplatesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (integration.getPassthroughBehavior() != null) {
                jsonGenerator.writeFieldName("passthroughBehavior").writeValue(integration.getPassthroughBehavior());
            }
            if (integration.getCacheNamespace() != null) {
                jsonGenerator.writeFieldName("cacheNamespace").writeValue(integration.getCacheNamespace());
            }
            if ((cacheKeyParametersList = integration.getCacheKeyParameters()) != null) {
                jsonGenerator.writeFieldName("cacheKeyParameters");
                jsonGenerator.writeStartArray();
                for (String cacheKeyParametersListValue : cacheKeyParametersList) {
                    if (cacheKeyParametersListValue == null) continue;
                    jsonGenerator.writeValue(cacheKeyParametersListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((integrationResponsesMap = integration.getIntegrationResponses()) != null) {
                jsonGenerator.writeFieldName("integrationResponses");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, IntegrationResponse> integrationResponsesMapValue : integrationResponsesMap.entrySet()) {
                    if (integrationResponsesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(integrationResponsesMapValue.getKey());
                    IntegrationResponseJsonMarshaller.getInstance().marshall(integrationResponsesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IntegrationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IntegrationJsonMarshaller();
        }
        return instance;
    }
}

