/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudsearchv2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.cloudsearchv2.model.DateArrayOptions;
import com.amazonaws.services.cloudsearchv2.model.DateOptions;
import com.amazonaws.services.cloudsearchv2.model.DefineIndexFieldRequest;
import com.amazonaws.services.cloudsearchv2.model.DoubleArrayOptions;
import com.amazonaws.services.cloudsearchv2.model.DoubleOptions;
import com.amazonaws.services.cloudsearchv2.model.IndexField;
import com.amazonaws.services.cloudsearchv2.model.IntArrayOptions;
import com.amazonaws.services.cloudsearchv2.model.IntOptions;
import com.amazonaws.services.cloudsearchv2.model.LatLonOptions;
import com.amazonaws.services.cloudsearchv2.model.LiteralArrayOptions;
import com.amazonaws.services.cloudsearchv2.model.LiteralOptions;
import com.amazonaws.services.cloudsearchv2.model.TextArrayOptions;
import com.amazonaws.services.cloudsearchv2.model.TextOptions;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DefineIndexFieldRequestMarshaller
implements Marshaller<Request<DefineIndexFieldRequest>, DefineIndexFieldRequest> {
    public Request<DefineIndexFieldRequest> marshall(DefineIndexFieldRequest defineIndexFieldRequest) {
        IndexField indexField;
        if (defineIndexFieldRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)defineIndexFieldRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DefineIndexField");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (defineIndexFieldRequest.getDomainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)defineIndexFieldRequest.getDomainName()));
        }
        if ((indexField = defineIndexFieldRequest.getIndexField()) != null) {
            DateArrayOptions dateArrayOptions;
            TextArrayOptions textArrayOptions;
            LiteralArrayOptions literalArrayOptions;
            DoubleArrayOptions doubleArrayOptions;
            IntArrayOptions intArrayOptions;
            LatLonOptions latLonOptions;
            DateOptions dateOptions;
            TextOptions textOptions;
            LiteralOptions literalOptions;
            DoubleOptions doubleOptions;
            IntOptions intOptions;
            if (indexField.getIndexFieldName() != null) {
                request.addParameter("IndexField.IndexFieldName", StringUtils.fromString((String)indexField.getIndexFieldName()));
            }
            if (indexField.getIndexFieldType() != null) {
                request.addParameter("IndexField.IndexFieldType", StringUtils.fromString((String)indexField.getIndexFieldType()));
            }
            if ((intOptions = indexField.getIntOptions()) != null) {
                if (intOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.IntOptions.DefaultValue", StringUtils.fromLong((Long)intOptions.getDefaultValue()));
                }
                if (intOptions.getSourceField() != null) {
                    request.addParameter("IndexField.IntOptions.SourceField", StringUtils.fromString((String)intOptions.getSourceField()));
                }
                if (intOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)intOptions.getFacetEnabled()));
                }
                if (intOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)intOptions.getSearchEnabled()));
                }
                if (intOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)intOptions.getReturnEnabled()));
                }
                if (intOptions.getSortEnabled() != null) {
                    request.addParameter("IndexField.IntOptions.SortEnabled", StringUtils.fromBoolean((Boolean)intOptions.getSortEnabled()));
                }
            }
            if ((doubleOptions = indexField.getDoubleOptions()) != null) {
                if (doubleOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.DoubleOptions.DefaultValue", StringUtils.fromDouble((Double)doubleOptions.getDefaultValue()));
                }
                if (doubleOptions.getSourceField() != null) {
                    request.addParameter("IndexField.DoubleOptions.SourceField", StringUtils.fromString((String)doubleOptions.getSourceField()));
                }
                if (doubleOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.getFacetEnabled()));
                }
                if (doubleOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.getSearchEnabled()));
                }
                if (doubleOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.getReturnEnabled()));
                }
                if (doubleOptions.getSortEnabled() != null) {
                    request.addParameter("IndexField.DoubleOptions.SortEnabled", StringUtils.fromBoolean((Boolean)doubleOptions.getSortEnabled()));
                }
            }
            if ((literalOptions = indexField.getLiteralOptions()) != null) {
                if (literalOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.LiteralOptions.DefaultValue", StringUtils.fromString((String)literalOptions.getDefaultValue()));
                }
                if (literalOptions.getSourceField() != null) {
                    request.addParameter("IndexField.LiteralOptions.SourceField", StringUtils.fromString((String)literalOptions.getSourceField()));
                }
                if (literalOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)literalOptions.getFacetEnabled()));
                }
                if (literalOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)literalOptions.getSearchEnabled()));
                }
                if (literalOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)literalOptions.getReturnEnabled()));
                }
                if (literalOptions.getSortEnabled() != null) {
                    request.addParameter("IndexField.LiteralOptions.SortEnabled", StringUtils.fromBoolean((Boolean)literalOptions.getSortEnabled()));
                }
            }
            if ((textOptions = indexField.getTextOptions()) != null) {
                if (textOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.TextOptions.DefaultValue", StringUtils.fromString((String)textOptions.getDefaultValue()));
                }
                if (textOptions.getSourceField() != null) {
                    request.addParameter("IndexField.TextOptions.SourceField", StringUtils.fromString((String)textOptions.getSourceField()));
                }
                if (textOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)textOptions.getReturnEnabled()));
                }
                if (textOptions.getSortEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.SortEnabled", StringUtils.fromBoolean((Boolean)textOptions.getSortEnabled()));
                }
                if (textOptions.getHighlightEnabled() != null) {
                    request.addParameter("IndexField.TextOptions.HighlightEnabled", StringUtils.fromBoolean((Boolean)textOptions.getHighlightEnabled()));
                }
                if (textOptions.getAnalysisScheme() != null) {
                    request.addParameter("IndexField.TextOptions.AnalysisScheme", StringUtils.fromString((String)textOptions.getAnalysisScheme()));
                }
            }
            if ((dateOptions = indexField.getDateOptions()) != null) {
                if (dateOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.DateOptions.DefaultValue", StringUtils.fromString((String)dateOptions.getDefaultValue()));
                }
                if (dateOptions.getSourceField() != null) {
                    request.addParameter("IndexField.DateOptions.SourceField", StringUtils.fromString((String)dateOptions.getSourceField()));
                }
                if (dateOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)dateOptions.getFacetEnabled()));
                }
                if (dateOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)dateOptions.getSearchEnabled()));
                }
                if (dateOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)dateOptions.getReturnEnabled()));
                }
                if (dateOptions.getSortEnabled() != null) {
                    request.addParameter("IndexField.DateOptions.SortEnabled", StringUtils.fromBoolean((Boolean)dateOptions.getSortEnabled()));
                }
            }
            if ((latLonOptions = indexField.getLatLonOptions()) != null) {
                if (latLonOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.LatLonOptions.DefaultValue", StringUtils.fromString((String)latLonOptions.getDefaultValue()));
                }
                if (latLonOptions.getSourceField() != null) {
                    request.addParameter("IndexField.LatLonOptions.SourceField", StringUtils.fromString((String)latLonOptions.getSourceField()));
                }
                if (latLonOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.getFacetEnabled()));
                }
                if (latLonOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.getSearchEnabled()));
                }
                if (latLonOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.getReturnEnabled()));
                }
                if (latLonOptions.getSortEnabled() != null) {
                    request.addParameter("IndexField.LatLonOptions.SortEnabled", StringUtils.fromBoolean((Boolean)latLonOptions.getSortEnabled()));
                }
            }
            if ((intArrayOptions = indexField.getIntArrayOptions()) != null) {
                if (intArrayOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.IntArrayOptions.DefaultValue", StringUtils.fromLong((Long)intArrayOptions.getDefaultValue()));
                }
                if (intArrayOptions.getSourceFields() != null) {
                    request.addParameter("IndexField.IntArrayOptions.SourceFields", StringUtils.fromString((String)intArrayOptions.getSourceFields()));
                }
                if (intArrayOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)intArrayOptions.getFacetEnabled()));
                }
                if (intArrayOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)intArrayOptions.getSearchEnabled()));
                }
                if (intArrayOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.IntArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)intArrayOptions.getReturnEnabled()));
                }
            }
            if ((doubleArrayOptions = indexField.getDoubleArrayOptions()) != null) {
                if (doubleArrayOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.DefaultValue", StringUtils.fromDouble((Double)doubleArrayOptions.getDefaultValue()));
                }
                if (doubleArrayOptions.getSourceFields() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.SourceFields", StringUtils.fromString((String)doubleArrayOptions.getSourceFields()));
                }
                if (doubleArrayOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)doubleArrayOptions.getFacetEnabled()));
                }
                if (doubleArrayOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)doubleArrayOptions.getSearchEnabled()));
                }
                if (doubleArrayOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.DoubleArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)doubleArrayOptions.getReturnEnabled()));
                }
            }
            if ((literalArrayOptions = indexField.getLiteralArrayOptions()) != null) {
                if (literalArrayOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.DefaultValue", StringUtils.fromString((String)literalArrayOptions.getDefaultValue()));
                }
                if (literalArrayOptions.getSourceFields() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.SourceFields", StringUtils.fromString((String)literalArrayOptions.getSourceFields()));
                }
                if (literalArrayOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)literalArrayOptions.getFacetEnabled()));
                }
                if (literalArrayOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)literalArrayOptions.getSearchEnabled()));
                }
                if (literalArrayOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.LiteralArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)literalArrayOptions.getReturnEnabled()));
                }
            }
            if ((textArrayOptions = indexField.getTextArrayOptions()) != null) {
                if (textArrayOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.TextArrayOptions.DefaultValue", StringUtils.fromString((String)textArrayOptions.getDefaultValue()));
                }
                if (textArrayOptions.getSourceFields() != null) {
                    request.addParameter("IndexField.TextArrayOptions.SourceFields", StringUtils.fromString((String)textArrayOptions.getSourceFields()));
                }
                if (textArrayOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.TextArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)textArrayOptions.getReturnEnabled()));
                }
                if (textArrayOptions.getHighlightEnabled() != null) {
                    request.addParameter("IndexField.TextArrayOptions.HighlightEnabled", StringUtils.fromBoolean((Boolean)textArrayOptions.getHighlightEnabled()));
                }
                if (textArrayOptions.getAnalysisScheme() != null) {
                    request.addParameter("IndexField.TextArrayOptions.AnalysisScheme", StringUtils.fromString((String)textArrayOptions.getAnalysisScheme()));
                }
            }
            if ((dateArrayOptions = indexField.getDateArrayOptions()) != null) {
                if (dateArrayOptions.getDefaultValue() != null) {
                    request.addParameter("IndexField.DateArrayOptions.DefaultValue", StringUtils.fromString((String)dateArrayOptions.getDefaultValue()));
                }
                if (dateArrayOptions.getSourceFields() != null) {
                    request.addParameter("IndexField.DateArrayOptions.SourceFields", StringUtils.fromString((String)dateArrayOptions.getSourceFields()));
                }
                if (dateArrayOptions.getFacetEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.FacetEnabled", StringUtils.fromBoolean((Boolean)dateArrayOptions.getFacetEnabled()));
                }
                if (dateArrayOptions.getSearchEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.SearchEnabled", StringUtils.fromBoolean((Boolean)dateArrayOptions.getSearchEnabled()));
                }
                if (dateArrayOptions.getReturnEnabled() != null) {
                    request.addParameter("IndexField.DateArrayOptions.ReturnEnabled", StringUtils.fromBoolean((Boolean)dateArrayOptions.getReturnEnabled()));
                }
            }
        }
        return request;
    }
}

