/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.junit;

import com.amazonaws.services.simpleworkflow.flow.DecisionContext;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncScope;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import com.amazonaws.services.simpleworkflow.flow.core.Settable;
import com.amazonaws.services.simpleworkflow.flow.core.Task;
import com.amazonaws.services.simpleworkflow.flow.junit.WorkflowTestStatement;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowClock;
import com.amazonaws.services.simpleworkflow.flow.test.TestWorkflowContext;
import com.amazonaws.services.simpleworkflow.flow.worker.CurrentDecisionContext;
import com.amazonaws.services.simpleworkflow.model.WorkflowExecution;
import com.amazonaws.services.simpleworkflow.model.WorkflowType;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public abstract class WorkflowTestBase
implements MethodRule {
    protected String defaultActivitiesTaskListToPoll = "TestTaskList";
    boolean disableOutstandingTasksCheck;
    protected DecisionContext decisionContext;
    protected TestWorkflowContext workflowContext;
    protected TestWorkflowClock workflowClock;
    AsyncScope scope;
    List<Settable<Void>> waits = new ArrayList<Settable<Void>>();
    double clockAcceleration = 1.0;
    boolean flowTestRunner;
    private long testTimeoutActualTimeMilliseconds;
    private WorkflowTestStatement workflowTestStatement;
    private Class<? extends Throwable> expectedException;

    public WorkflowTestBase(DecisionContext decisionContext) {
        this.decisionContext = decisionContext;
        this.workflowContext = (TestWorkflowContext)decisionContext.getWorkflowContext();
        this.workflowClock = (TestWorkflowClock)decisionContext.getWorkflowClock();
        WorkflowExecution we = new WorkflowExecution();
        we.setWorkflowId("testWorkflowId");
        we.setRunId("testRunId");
        this.workflowContext.setWorkflowExecution(we);
        WorkflowType wt = new WorkflowType();
        wt.setName("testWorkflow");
        wt.setVersion("0.0");
        this.workflowContext.setWorkflowType(wt);
    }

    public boolean isDisableOutstandingTasksCheck() {
        return this.disableOutstandingTasksCheck;
    }

    public void setDisableOutstandingTasksCheck(boolean disableOutstandingTasksCheck) {
        this.disableOutstandingTasksCheck = disableOutstandingTasksCheck;
    }

    public DecisionContext getDecisionContext() {
        return this.decisionContext;
    }

    public void setWorkflowExecution(WorkflowExecution workflowExecution) {
        this.workflowContext.setWorkflowExecution(workflowExecution);
    }

    public void setWorkflowType(WorkflowType workflowType) {
        this.workflowContext.setWorkflowType(workflowType);
    }

    public WorkflowExecution getWorkflowExecution() {
        return this.workflowContext.getWorkflowExecution();
    }

    public WorkflowType getWorkflowType() {
        return this.workflowContext.getWorkflowType();
    }

    public String getDefaultActivitiesTaskListToPoll() {
        return this.defaultActivitiesTaskListToPoll;
    }

    public void setDefaultActivitiesTaskListToPoll(String defaultActivitiesTaskListToPoll) {
        this.defaultActivitiesTaskListToPoll = defaultActivitiesTaskListToPoll;
    }

    public double getClockAcceleration() {
        return this.clockAcceleration;
    }

    public void setClockAccelerationCoefficient(double clockAcceleration) {
        if (clockAcceleration < 1.0) {
            throw new IllegalArgumentException("clock acceleration less then 1: " + clockAcceleration);
        }
        this.clockAcceleration = clockAcceleration;
    }

    public Statement apply(Statement base, FrameworkMethod method, Object target) {
        Callable<WorkflowTestBase> accessor = new Callable<WorkflowTestBase>(){

            @Override
            public WorkflowTestBase call() throws Exception {
                return WorkflowTestBase.this;
            }
        };
        this.workflowTestStatement = new WorkflowTestStatement(accessor, base, this.testTimeoutActualTimeMilliseconds, this.expectedException);
        this.workflowTestStatement.setFlowTestRunner(this.flowTestRunner);
        return this.workflowTestStatement;
    }

    public Promise<Void> waitBlocked(Promise<?> ... waitFor) {
        if (this.scope == null) {
            throw new IllegalArgumentException("Called outside of test method");
        }
        final Settable<Void> result = new Settable<Void>();
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                WorkflowTestBase.this.waits.add(result);
            }
        };
        return result;
    }

    public void setClockCurrentTimeMillis(long timeMillis) {
        this.workflowClock.setCurrentTimeMillis(timeMillis);
    }

    public void clockAdvanceSeconds(long seconds) {
        this.workflowClock.advanceSeconds(seconds);
    }

    public void clockAdvanceSeconds(final long seconds, Promise<?> ... waitFor) {
        new Task((Promise[])waitFor){

            @Override
            protected void doExecute() throws Throwable {
                WorkflowTestBase.this.workflowClock.advanceSeconds(seconds);
            }
        };
    }

    protected void beforeEvaluate(DecisionContext decisionContext) {
        CurrentDecisionContext.set(decisionContext);
    }

    protected void afterEvaluate() {
        CurrentDecisionContext.unset();
    }

    public void setTestTimeoutActualTimeMilliseconds(long timeout) {
        this.testTimeoutActualTimeMilliseconds = timeout;
        if (this.workflowTestStatement != null) {
            this.workflowTestStatement.setTestTimeoutActualTimeMilliseconds(timeout);
        }
    }

    public void setExpectedException(Class<? extends Throwable> expectedException) {
        this.expectedException = expectedException;
        if (this.workflowTestStatement != null) {
            this.workflowTestStatement.setExpectedException(expectedException);
        }
    }

    public void setFlowTestRunner(boolean flowTestRunner) {
        this.flowTestRunner = flowTestRunner;
        if (this.workflowTestStatement != null) {
            this.workflowTestStatement.setFlowTestRunner(flowTestRunner);
        }
    }
}

