import logging
import spacy
#from base_cpu import Base
from datetime import date, timedelta
from kapture_first_objectextract_dict import First_level_dict
from kapture_second_objectextract_dict import Second_level_dict
from kapture_first_level_tense_dict import TenseDict
from kapture_second_level_tense_dict import Final_Tense_Dict
from kapture_week_month_dict import Week_Month_Dict
from kapture_week_days_dict import Week_Days_Dict
from kapture_number_dict import Number_Dict
from kapture_document_word_synonym import Document_word_synonym
class NerSp():

    def __init__(self):
        self.sentence=""
    #Main Module to invoke other modules
    def parse(self, sentence):
        nlp = spacy.load("en_core_web_sm")
        doc = nlp(sentence)

        #for entity in doc.ents:
           # print(entity.label_, ' | ', entity.text)
            #self.logger.debug("-" * 70)
            #self.logger.debug("{:<15} | {:<8} | {:<15} | {:<20} | {:<20} | {:<20}".format('Token','Relation','Head', 'Children', 'POS', 'Lemma'))
            #self.logger.debug("-" * 70)


        d = {}
        d3={}
        
       # for token in doc:
            #if token.ent_type_ != "":
              #  d[token.lemma_] =  token.ent_type_

        #self.logger.info(d)
        d4=self.type_identification(sentence)
        if d4['type']=='type_1':
            #print("In Type 1 call")
            d1=self.subject_extraction(sentence)
            d.update(d1)
            d2=self.Object_extraction(sentence)
            d.update(d2)
            for entity in doc.ents:
                #print(entity.label_, ' | ', entity.text)
                if (entity.label_ == 'DATE'):
                     d3=self.Date_extraction(sentence)

            d.update(d3)
            d.update(d4)
        elif d4['type']=='type_2':
            d.update(d4)
        elif d4['type'] =='keyword':
            d.update(d4)
        return (d)
    #Type Identification Module
    def type_identification(self, sentence):
        d4={}
        c1 = Document_word_synonym()
        t = c1.add()
        #print(t)
        type = False
        keyword_type=False
        nlp = spacy.load("en_core_web_sm")
        doc = nlp(sentence)
        #print(doc)
        type2_reserve_word_list = ['How', 'When', 'What', 'Why', 'Who', 'Where', 'Which']
        lowercased_tokens=""
        for token in doc:

            if (token.text.lower() in (item.lower() for item in type2_reserve_word_list)) :
                type = False
                #print('This is Type 2 question')
                # break
            elif token.text.lower() in (key.lower() for key in t):
                #print('This is Type 1 question')
                type = True
                # break
            lowercased_tokens=lowercased_tokens+ " "+ token.text.lower()
        elements = list(t.keys())
        elements.extend(type2_reserve_word_list)
        elements_set = set(elements)
        #print("lowercase senetence is",lowercased_tokens)
        #print("element set is", elements_set)
        for element in elements_set:
            if element.lower() in lowercased_tokens:
                keyword_type=True
                break
        if not keyword_type:
           d4['type'] = 'keyword'
        elif  keyword_type:
          if type and 'type' not in d4 :
            d4['type']='type_1'
            #print ("In Type 1")
          elif (not type) and ('type' not in d4):
            d4['type'] = 'type_2'
            #print("In Type 2")
        return(d4)
    # Index Name Extraction Module
    def subject_extraction(self, sentence):
        subject1 = None
        subject2 = None
        nlp = spacy.load("en_core_web_sm")
        doc = nlp(sentence)
        d1 = {}

        for token in doc:

            # if(token.dep_=='pobj'):
            #        print(token.head.text)
            #      print(str([child for child in token.head.children]))

            if (token.dep_ == 'compound'):
                #print(token.text)
                subject1 = token.text

            if (token.dep_ == 'acl'):
                #print(token.head.text)
                subject2 = token.head.text
                break

        if subject1:
            # print('variable is not None')
            subject_dictionary_mapping = {'Subject': 'all.' + subject1.lower() + '.en_us/_search'}
            #print(subject_dictionary_mapping['Subject'])
            #d1['all.' + subject1.lower() + '.en_us/_search' ] = subject1
            #d1['index_name']=subject1
            d1['all'] = subject1

        if subject1 is None and subject2:
            # print('Hello')
            subject_dictionary_mapping = {'Subject': 'all.en_us/_search'}
            #print(subject_dictionary_mapping['Subject'])
            #d1['all.en_us/_search'] = subject2
            #d1['index_name'] = subject2
            d1['all'] = subject2
        #self.logger.info(d1)
        return(d1)

    # Key-Value Pair Extraction Module
    def Object_extraction(self, sentence):
        key = None
        value = None
        valuelist = []
        keylist = []
        counter = 0
        counter1 = 0
        entitytext = []
        entitylabel = []
        j=0
        i=0

        c1 = First_level_dict()
        d=c1.add()


        c2 = Second_level_dict()
        d1=c2.add()

        nlp = spacy.load("en_core_web_sm")
        doc = nlp(sentence)
        d2 = {}
        for entity in doc.ents:
            # print(entity.label_, ' | ', entity.text)
            # print(entity.text)
            # print(entity.label_)
            entitytext.append(entity.text)
            entitylabel.append(entity.label_)

        for token in doc:
            for child in token.children:
                # print(child)
                if (child.dep_ == 'dobj'):
                    #for child1 in child.children:
                        #print(child1.text)
                        #print(child1.dep_)
                    if (counter1 == 0):
                        #print("in dobj1")
                        keylist.append(child.text)
                        counter1 = counter1 + 1
                # counter1=counter1+1;
                # print(counter1)
                if (child.pos_ == 'VERB'):
                    for child in child.children:
                        if (child.dep_ == 'agent'):
                            #print("in agent")
                            keylist.append(child.head.lemma_)
                        if (child.dep_ == 'dobj'):
                            if (counter1 == 0):
                                #print("in dobj2")
                                keylist.append(child.text)
                                counter1 = counter1 + 1
                            # print('Hello')
                if (child.dep_ == 'pobj'):
                    value = child.text
                    #print("Value is"+value)
                    #print("lenghth is" , len(entitylabel))
                    if len(entitylabel)==0:
                        valuelist.append(value)
                    for index in range(len(entitylabel)):
                        #print("index is",index)
                        #print("lenghth is" , len(entitylabel))
                        if (entitylabel[index] == 'DATE'):
                            counter = counter + 1
                        if (entitylabel[index] == 'DATE' and value not in entitytext[index]):
                            valuelist.append(value)
                        if (len(entitylabel) == index + 1  and counter == 0):
                            valuelist.append(value)
                    #print("Valuelist is inner", valuelist)
               

        #print("keylist is", keylist)
        #print("Valuelist is", valuelist)

        length_keylist=len(keylist)
        length_valuelist=len(valuelist)

        if length_keylist==length_valuelist:
             i=length_keylist
        elif length_keylist < length_valuelist:
             i=length_keylist
        else:
            i= length_valuelist

        while j < i:
           first_level_value = d[keylist[j]]
           second_level_key= d1[first_level_value]
           d2[second_level_key]=valuelist[j]

           #first_level_value1 = d[keylist[j]]
           #second_level_key1 = d1[first_level_value1]
           #d2[second_level_key1] = valuelist[j]
           j=j+1
        return(d2)
    # Resolving Date related sentences
    def Date_extraction(self, sentence):
        d3 = {}
        c1 = TenseDict()
        t = c1.add()
        c2=Final_Tense_Dict()
        tf=c2.add()
        c3=Week_Month_Dict()
        wm=c3.add()
        c4= Week_Days_Dict()
        wd=c4.add()
        c5= Number_Dict()
        num=c5.add()

        date_text = None
        week_month_value = 1
        number_value = 1
        second_level_tense = None
        nlp = spacy.load("en_core_web_sm")
        #sentence = 'Documents created by Abhijit in this month'
        doc = nlp(sentence)

        for entity in doc.ents:
            #print(entity.label_, ' | ', entity.text)
            if (entity.label_ == 'DATE'):
                date_text = entity.text
                # print(date_text)
        #print(date_text)
        date_text_list = date_text.split()
        #print("date text list is", date_text_list)

        # Code for Searching every word of 'Date' entity sentence and extracting the values from respective Dictionary
        for i in date_text_list:
            #print("i is", i)
            if i in t:
                #print("hello")
                first_level_tense = t[i]
                #print(first_level_tense)
                second_level_tense = tf[first_level_tense]
                #print("Second level tense is", " ", second_level_tense)
            elif i in wm:
                #print("hi")
                week_month_value = wm[i]
            elif i in num:
                #print("hey")
                number_value = num[i]
        #print(second_level_tense, week_month_value, number_value)
        if second_level_tense == 'substract':
            cd_pd = self.substract(week_month_value, number_value)
            #print(cd_pd)
            d3['lte']=cd_pd[0]
            d3['gte'] = cd_pd[1]
        if second_level_tense == 'current':
            cd_pd = self.current(week_month_value)
            #print(cd_pd)
            d3['lte'] = cd_pd[0]
            d3['gte'] = cd_pd[1]
        return (d3)

    def substract(self,week_month_value, number_value):
        total_no_of_days = week_month_value * number_value
        cd = date.today().isoformat()
        pd = (date.today() - timedelta(days=total_no_of_days)).isoformat()
        # print("Current Date: ",cd)
        # print(" Days Before Current Date: ",pd)
        return cd, pd

    def current(self,week_month_value):
        from datetime import datetime, date, timedelta
        if week_month_value == 30:
            today = date.today()
            start_day = today.replace(day=1)
            return today.isoformat(), start_day.isoformat()
        elif week_month_value == 7:
            today = date.today()
            last_monday = today - timedelta(days=today.weekday())
            return today.isoformat(), last_monday.isoformat()


#if __name__ == "__main__":
  #  sentence = 'Automobile Documents created by Abhijit having title as Tesla in last one week'
    #sentence = 'Documents created by Abhijit in last two month'
   # dp = NerSp()
   # d = dp.parse(sentence)
